/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.util.Vector;

public class ParameterBlock
implements Cloneable,
Serializable {
    protected Vector sources = new Vector();
    protected Vector parameters = new Vector();

    public int getNumParameters() {
        return this.parameters.size();
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public ParameterBlock() {
    }

    public void removeParameters() {
        this.parameters = new Vector();
    }

    public void removeSources() {
        this.sources = new Vector();
    }

    public byte getByteParameter(int n2) {
        return (Byte)this.parameters.elementAt(n2);
    }

    public char getCharParameter(int n2) {
        return ((Character)this.parameters.elementAt(n2)).charValue();
    }

    public double getDoubleParameter(int n2) {
        return (Double)this.parameters.elementAt(n2);
    }

    public float getFloatParameter(int n2) {
        return ((Float)this.parameters.elementAt(n2)).floatValue();
    }

    public int getIntParameter(int n2) {
        return (Integer)this.parameters.elementAt(n2);
    }

    public long getLongParameter(int n2) {
        return (Long)this.parameters.elementAt(n2);
    }

    public short getShortParameter(int n2) {
        return (Short)this.parameters.elementAt(n2);
    }

    public RenderedImage getRenderedSource(int n2) {
        return (RenderedImage)this.sources.elementAt(n2);
    }

    public ParameterBlock add(byte by) {
        return this.add(new Byte(by));
    }

    public ParameterBlock set(byte by, int n2) {
        return this.set(new Byte(by), n2);
    }

    public ParameterBlock add(char c2) {
        return this.add(new Character(c2));
    }

    public ParameterBlock set(char c2, int n2) {
        return this.set(new Character(c2), n2);
    }

    public ParameterBlock add(double d2) {
        return this.add(new Double(d2));
    }

    public ParameterBlock set(double d2, int n2) {
        return this.set(new Double(d2), n2);
    }

    public ParameterBlock add(float f2) {
        return this.add(new Float(f2));
    }

    public ParameterBlock set(float f2, int n2) {
        return this.set(new Float(f2), n2);
    }

    public ParameterBlock add(int n2) {
        return this.add(new Integer(n2));
    }

    public ParameterBlock set(int n2, int n3) {
        return this.set(new Integer(n2), n3);
    }

    public ParameterBlock add(long l2) {
        return this.add(new Long(l2));
    }

    public ParameterBlock set(long l2, int n2) {
        return this.set(new Long(l2), n2);
    }

    public ParameterBlock add(short s2) {
        return this.add(new Short(s2));
    }

    public ParameterBlock set(short s2, int n2) {
        return this.set(new Short(s2), n2);
    }

    public RenderableImage getRenderableSource(int n2) {
        return (RenderableImage)this.sources.elementAt(n2);
    }

    public Class[] getParamClasses() {
        int n2 = this.getNumParameters();
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getObjectParameter(i2);
            classArray[i2] = object instanceof Byte ? Byte.TYPE : (object instanceof Character ? Character.TYPE : (object instanceof Short ? Short.TYPE : (object instanceof Integer ? Integer.TYPE : (object instanceof Long ? Long.TYPE : (object instanceof Float ? Float.TYPE : (object instanceof Double ? Double.TYPE : object.getClass()))))));
        }
        return classArray;
    }

    public Object clone() {
        ParameterBlock parameterBlock;
        try {
            parameterBlock = (ParameterBlock)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
        if (this.sources != null) {
            parameterBlock.setSources((Vector)this.sources.clone());
        }
        if (this.parameters != null) {
            parameterBlock.setParameters((Vector)this.parameters.clone());
        }
        return parameterBlock;
    }

    public Object shallowClone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getObjectParameter(int n2) {
        return this.parameters.elementAt(n2);
    }

    public Object getSource(int n2) {
        return this.sources.elementAt(n2);
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public Vector getSources() {
        return this.sources;
    }

    public ParameterBlock(Vector vector) {
        this.setSources(vector);
    }

    public void setParameters(Vector vector) {
        this.parameters = vector;
    }

    public void setSources(Vector vector) {
        this.sources = vector;
    }

    public ParameterBlock add(Object object) {
        this.parameters.addElement(object);
        return this;
    }

    public ParameterBlock addSource(Object object) {
        this.sources.addElement(object);
        return this;
    }

    public ParameterBlock set(Object object, int n2) {
        int n3;
        int n4 = this.parameters.size();
        if (n4 < (n3 = n2 + 1)) {
            this.parameters.setSize(n3);
        }
        this.parameters.setElementAt(object, n2);
        return this;
    }

    public ParameterBlock setSource(Object object, int n2) {
        int n3;
        int n4 = this.sources.size();
        if (n4 < (n3 = n2 + 1)) {
            this.sources.setSize(n3);
        }
        this.sources.setElementAt(object, n2);
        return this;
    }

    public ParameterBlock(Vector vector, Vector vector2) {
        this.setSources(vector);
        this.setParameters(vector2);
    }
}

